#!/bin/bash

# Telegram Bot Setup Script
# Usage: bash setup.sh

echo "🤖 Telegram Group Assistant Bot - Setup"
echo "========================================"
echo ""

# Check PHP is installed
if ! command -v php &> /dev/null; then
    echo "❌ PHP is not installed. Please install PHP 7.4 or higher."
    exit 1
fi

echo "✅ PHP found: $(php -v | head -1)"
echo ""

# Check if config file exists
if [ ! -f "config/config.php" ]; then
    echo "❌ config/config.php not found!"
    exit 1
fi

# Ask for bot token
echo "📝 Let's configure your bot!"
echo ""
read -p "Enter your Telegram Bot Token: " BOT_TOKEN
read -p "Enter your Telegram User ID: " USER_ID

# Update config
sed -i "s/define('TELEGRAM_TOKEN', '.*');/define('TELEGRAM_TOKEN', '$BOT_TOKEN');/" config/config.php
sed -i "s/define('OWNER_ID', [0-9]*);/define('OWNER_ID', $USER_ID);/" config/config.php

echo ""
echo "✅ Configuration saved!"
echo ""
echo "🚀 Next steps:"
echo "1. Upload all files to your hosting"
echo "2. Make sure 'data/' directory is writable"
echo "3. Set webhook with this command:"
echo ""
echo "curl -X POST \"https://api.telegram.org/bot$BOT_TOKEN/setWebhook?url=https://yourdomain.com/webhook.php\""
echo ""
echo "📚 For more help, see README.md"
